<?php
// +----------------------------------------------------------------------
// | 海豚PHP框架 [ DolphinPHP ]
// +----------------------------------------------------------------------
// | 版权所有 2016~2017 河源市卓锐科技有限公司 [ http://www.zrthink.com ]
// +----------------------------------------------------------------------
// | 官方网站: http://dolphinphp.com
// +----------------------------------------------------------------------
// | 开源协议 ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------

namespace app\update\admin;

use app\common\controller\Common;
use think\Db;
use util\File;

/**
 * 仪表盘控制器
 * @package app\cms\admin
 */
class Index extends Common
{
    protected $version_from = '1.2.0';
    protected $version_to = '1.2.1';

    protected function _initialize()
    {
        parent::_initialize();
        if (config('dolphin.product_version') == $this->version_to) {
            die('<h1 style="text-align: center;color:red">当前版本已经是V'.$this->version_to.'，无需升级！</h1>');
        }
        if (config('dolphin.product_version') != $this->version_from) {
            $this->error('<h1 style="text-align: center;color:red">框架版本不符合，无法升级</h1>');
        }
    }

    /**
     * 首页
     * @return mixed
     */
    public function index()
    {
        $this->assign('version_from', '1.2.0');
        $this->assign('version_to', '1.2.1');
        return $this->fetch();
    }

    /**
     * 更新数据库
     */
    public function updatedata()
    {
        /**
         * ==============
         * 添加配置（开始）
         * ==============
         */
        $table_name = config('database.prefix').'admin_config';

        $sql = <<<EOF
                INSERT INTO `{$table_name}` VALUES (null, 'asset_version', '资源版本号', 'develop', 'text', '20180327', '', '可通过修改版号强制用户更新静态文件', '', '', '', '', '', '0', '', '', '', '', '1522143239', '1522143239', '100', '1');
EOF;
        try {
            Db::execute($sql);
        } catch(\Exception $e) {
            $this->error('表：'.$table_name.' 更新失败');
        }
        /**
         * ==============
         * 添加配置（结束）
         * ==============
         */

        $this->success('更新成功');
    }

    /**
     * 更新文件
     */
    public function updateFile()
    {
        // 复制静态资源目录
        if (false == File::copy_dir(APP_PATH. 'update/files/application', ROOT_PATH.'application')) {
            $this->error('application目录更新失败');
        }
        if (false == File::copy_dir(APP_PATH. 'update/files/public', ROOT_PATH.'public')) {
            $this->error('public目录更新失败');
        }
        $this->wipeCache();
        $this->success('更新成功');
    }

    /**
     * 清除缓存
     */
    private function wipeCache()
    {
        if (!empty(config('wipe_cache_type'))) {
            foreach (config('wipe_cache_type') as $item) {
                if ($item == 'LOG_PATH') {
                    $dirs = (array) glob(constant($item) . '*');
                    foreach ($dirs as $dir) {
                        array_map('unlink', glob($dir . '/*.log'));
                    }
                    array_map('rmdir', $dirs);
                } else {
                    array_map('unlink', glob(constant($item) . '/*.*'));
                }
            }
            \think\Cache::clear();
        }
    }
}