<?php
// +----------------------------------------------------------------------
// | 海豚PHP框架 [ DolphinPHP ]
// +----------------------------------------------------------------------
// | 版权所有 2016~2017 河源市卓锐科技有限公司 [ http://www.zrthink.com ]
// +----------------------------------------------------------------------
// | 官方网站: http://dolphinphp.com
// +----------------------------------------------------------------------
// | 开源协议 ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------

namespace app\update\admin;

use app\common\controller\Common;
use think\Db;
use think\facade\Cache;
use util\File;
use think\facade\Env;

/**
 * 仪表盘控制器
 * @package app\cms\admin
 */
class Index extends Common
{
    protected $version_from = '1.6.0';
    protected $version_to = '1.7.0';

    protected function initialize()
    {
        parent::initialize();
        if (config('dolphin.product_version') == $this->version_to) {
            die('<h1 style="text-align: center;color:red">当前版本已经是V'.$this->version_to.'，无需升级！</h1>');
        }
        if (config('dolphin.product_version') != $this->version_from) {
            $this->error('<h1 style="text-align: center;color:red">框架版本不符合，无法升级</h1>');
        }
    }

    /**
     * 首页
     * @return mixed
     */
    public function index()
    {
        $this->assign('version_from', $this->version_from);
        $this->assign('version_to', $this->version_to);
        return $this->fetch();
    }

    /**
     * 更新数据库
     */
    public function updatedata()
    {
        /**
         * ==============
         * 添加副角色支持（开始）
         * ==============
         */

        /**
         * ==============
         * 添加副角色支持（结束）
         * ==============
         */
        $this->success('更新成功');
    }

    /**
     * 更新文件
     */
    public function updateFile()
    {
        // 复制静态资源目录
        if (false == File::copy_dir(Env::get('app_path'). 'update/files/application', Env::get('root_path').'application')) {
            $this->error('application目录更新失败');
        }
        if (false == File::copy_dir(Env::get('app_path'). 'update/files/config', Env::get('root_path').'config')) {
            $this->error('config目录更新失败');
        }
        if (false == File::copy_dir(Env::get('app_path'). 'update/files/thinkphp', Env::get('root_path').'thinkphp')) {
            $this->error('thinkphp目录更新失败');
        }
        $this->wipeCache();
        $this->success('更新成功');
    }

    /**
     * 清除缓存
     */
    private function wipeCache()
    {
        $wipe_cache_type = config('wipe_cache_type');
        if (!empty($wipe_cache_type)) {
            foreach ($wipe_cache_type as $item) {
                switch ($item) {
                    case 'TEMP_PATH':
                        array_map('unlink', glob(Env::get('runtime_path'). 'temp/*.*'));
                        break;
                    case 'CACHE_PATH':
                        array_map('unlink', glob(Env::get('runtime_path'). 'cache/*.*'));
                        break;
                }
            }
            Cache::clear();
            $this->success('清空成功');
        } else {
            $this->error('请在系统设置中选择需要清除的缓存类型');
        }
    }
}